<?php

namespace App\Hosts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Hosts extends Model 
{

    protected $table = 'Host';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Hosts()
    {
        return $this->hasMany('HostVulnerability');
    }

    public function hostsHasScan()
    {
        return $this->hasOne('Scans');
    }

}